



<!-- Enhanced Medical Report Upload Section -->
<style>
    :root {
        --primary-teal: #17a2b8;
        --secondary-teal: #60C5B7;
        --dark-teal: #138496;
        --light-teal: #e8f4f8;
    }

    .upload-container {
        background: linear-gradient(135deg, var(--secondary-teal) 0%, var(--primary-teal) 100%);
        padding: 2rem;
        border-radius: 1rem;
        margin: 2rem 0;
    }

    .upload-card {
        background: white;
        border-radius: 20px;
        box-shadow: 0 20px 60px rgba(0, 0, 0, 0.1);
        overflow: hidden;
        max-width: 600px;
        width: 100%;
        margin: 0 auto;
        position: relative;
    }

    .upload-header {
        background: linear-gradient(135deg, var(--primary-teal), var(--dark-teal));
        color: white;
        padding: 2rem;
        text-align: center;
        position: relative;
    }

    .upload-header::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><defs><pattern id="grid" width="10" height="10" patternUnits="userSpaceOnUse"><path d="M 10 0 L 0 0 0 10" fill="none" stroke="rgba(255,255,255,0.1)" stroke-width="0.5"/></pattern></defs><rect width="100" height="100" fill="url(%23grid)"/></svg>');
        opacity: 0.3;
    }

    .upload-header h2 {
        position: relative;
        z-index: 1;
        margin-bottom: 0.5rem;
    }

    .upload-header p {
        position: relative;
        z-index: 1;
        margin-bottom: 0;
        opacity: 0.9;
    }

    .upload-body {
        padding: 3rem 2rem;
    }

    .file-drop-zone {
        border: 3px dashed #cbd5e0;
        border-radius: 15px;
        padding: 3rem 2rem;
        text-align: center;
        transition: all 0.3s ease;
        background: var(--light-teal);
        position: relative;
        overflow: hidden;
    }

    .file-drop-zone:hover {
        border-color: var(--primary-teal);
        background: rgba(23, 162, 184, 0.1);
        transform: translateY(-2px);
    }

    .file-drop-zone.dragover {
        border-color: var(--primary-teal);
        background: rgba(23, 162, 184, 0.15);
        transform: scale(1.02);
    }

    .upload-icon {
        font-size: 4rem;
        color: var(--primary-teal);
        margin-bottom: 1rem;
        animation: float 3s ease-in-out infinite;
    }

    @keyframes  float {
        0%, 100% { transform: translateY(0px); }
        50% { transform: translateY(-10px); }
    }

    .file-input {
        display: none;
    }

    .upload-btn {
        background: linear-gradient(135deg, var(--primary-teal), var(--dark-teal));
        border: none;
        color: white;
        padding: 1rem 2rem;
        border-radius: 50px;
        font-weight: 600;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        transition: all 0.3s ease;
        box-shadow: 0 8px 25px rgba(23, 162, 184, 0.3);
        position: relative;
        overflow: hidden;
    }

    .upload-btn:hover {
        transform: translateY(-3px);
        box-shadow: 0 12px 35px rgba(23, 162, 184, 0.4);
        background: linear-gradient(135deg, var(--dark-teal), var(--primary-teal));
        color: white;
    }

    .upload-btn::before {
        content: '';
        position: absolute;
        top: 0;
        left: -100%;
        width: 100%;
        height: 100%;
        background: linear-gradient(90deg, transparent, rgba(255,255,255,0.2), transparent);
        transition: left 0.5s;
    }

    .upload-btn:hover::before {
        left: 100%;
    }

    .file-info {
        background: #f8f9fa;
        border-radius: 10px;
        padding: 1rem;
        margin-top: 1rem;
        display: none;
    }

    .file-info.show {
        display: block;
        animation: slideIn 0.3s ease;
    }

    @keyframes  slideIn {
        from { opacity: 0; transform: translateY(-10px); }
        to { opacity: 1; transform: translateY(0); }
    }

    .supported-formats {
        display: flex;
        justify-content: center;
        gap: 1rem;
        margin-top: 1.5rem;
        flex-wrap: wrap;
    }

    .format-badge {
        background: rgba(23, 162, 184, 0.1);
        color: var(--primary-teal);
        padding: 0.5rem 1rem;
        border-radius: 20px;
        font-size: 0.8rem;
        font-weight: 600;
        border: 1px solid rgba(23, 162, 184, 0.2);
    }

    .progress-container {
        margin-top: 1rem;
        display: none;
    }

    .progress-container.show {
        display: block;
        animation: slideIn 0.3s ease;
    }

    .progress {
        height: 8px;
        border-radius: 10px;
        background: #e9ecef;
        overflow: hidden;
    }

    .progress-bar {
        background: linear-gradient(90deg, var(--primary-teal), var(--secondary-teal));
        transition: width 0.3s ease;
    }

    .security-info {
        background: #f8f9fa;
        border-left: 4px solid var(--primary-teal);
        padding: 1rem;
        margin-top: 2rem;
        border-radius: 0 10px 10px 0;
    }

    .whatsapp-option {
        background: linear-gradient(135deg, #25D366, #128C7E);
        color: white;
        padding: 1.5rem;
        border-radius: 15px;
        margin-top: 2rem;
        text-align: center;
        position: relative;
        overflow: hidden;
    }

    .whatsapp-option::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: radial-gradient(circle at 50% 50%, rgba(255,255,255,0.1) 0%, transparent 70%);
    }

    .whatsapp-btn {
        background: rgba(255, 255, 255, 0.2);
        border: 2px solid rgba(255, 255, 255, 0.3);
        color: white;
        padding: 0.75rem 1.5rem;
        border-radius: 30px;
        text-decoration: none;
        display: inline-block;
        transition: all 0.3s ease;
        font-weight: 600;
        position: relative;
        z-index: 1;
    }

    .whatsapp-btn:hover {
        background: rgba(255, 255, 255, 0.3);
        border-color: rgba(255, 255, 255, 0.5);
        color: white;
        transform: translateY(-2px);
        text-decoration: none;
    }

    @media (max-width: 768px) {
        .upload-container {
            padding: 1rem;
        }

        .upload-header {
            padding: 1.5rem;
        }

        .upload-body {
            padding: 2rem 1.5rem;
        }

        .file-drop-zone {
            padding: 2rem 1rem;
        }

        .upload-icon {
            font-size: 3rem;
        }

        .supported-formats {
            gap: 0.5rem;
        }

        .format-badge {
            font-size: 0.7rem;
            padding: 0.4rem 0.8rem;
        }
    }
</style>

<div class="upload-container">
    <div class="upload-card">
        <!-- Header -->
        <div class="upload-header">
            <i class="fas fa-file-medical-alt mb-3" style="font-size: 3rem;"></i>
            <h2 class="h3 mb-2">Upload Your Medical Report</h2>
            <p class="mb-0">Get professional analysis of your test results instantly</p>
        </div>

        <!-- Upload Body -->
        <div class="upload-body">
            <!-- File Drop Zone -->
            <!-- <div class="file-drop-zone" id="dropZone">
                <i class="fas fa-cloud-upload-alt upload-icon"></i>
                <h4 class="h5 mb-3 text-muted">Drag & drop your file here</h4>
                <p class="text-muted mb-3">or</p>
                <button type="button" class="btn upload-btn" onclick="document.getElementById('fileInput').click()">
                    <i class="fas fa-folder-open me-2"></i>
                    Browse Files
                </button>
                <input type="file" id="fileInput" class="file-input" accept=".pdf,.jpg,.jpeg,.png,.doc,.docx" multiple>
            </div> -->

            <!-- File Info -->
            <!-- <div class="file-info" id="fileInfo">
                <div class="d-flex align-items-center">
                    <i class="fas fa-file-alt text-primary me-2"></i>
                    <div class="flex-grow-1">
                        <div class="fw-bold" id="fileName">No file selected</div>
                        <small class="text-muted" id="fileSize">0 KB</small>
                    </div>
                    <button class="btn btn-sm btn-outline-danger" onclick="clearFile()">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
            </div> -->

            <!-- Progress Bar -->
            <!-- <div class="progress-container" id="progressContainer">
                <div class="d-flex justify-content-between align-items-center mb-2">
                    <span class="small text-muted">Uploading...</span>
                    <span class="small text-muted" id="progressText">0%</span>
                </div>
                <div class="progress">
                    <div class="progress-bar" id="progressBar" style="width: 0%"></div>
                </div>
            </div> -->

            <!-- WhatsApp Alternative -->
            <div class="whatsapp-option">
                <h5 class="mb-2">
                    <i class="fab fa-whatsapp me-2"></i>
                     WhatsApp Upload
                </h5>
                <p class="mb-3 opacity-90">Send your report directly via WhatsApp for instant analysis</p>
                <a href="https://wa.me/+19512073835" target="_blank" class="whatsapp-btn">
                    <i class="fab fa-whatsapp me-2"></i>
                    Send via WhatsApp
                </a>
            </div>

            <!-- Supported Formats -->
            <div class="supported-formats">
                <span class="format-badge"><i class="fas fa-file-pdf me-1"></i>PDF</span>
                <span class="format-badge"><i class="fas fa-file-image me-1"></i>JPG</span>
                <span class="format-badge"><i class="fas fa-file-image me-1"></i>PNG</span>
                <span class="format-badge"><i class="fas fa-file-word me-1"></i>DOC</span>
            </div>

            <!-- Security Info -->
            <div class="security-info">
                <div class="d-flex align-items-center">
                    <i class="fas fa-shield-alt text-primary me-2"></i>
                    <div>
                        <strong>100% Secure & Confidential</strong>
                        <p class="mb-0 small text-muted">Your medical reports are encrypted and kept completely private</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<?php if (! $__env->hasRenderedOnce('2310a18b-c867-4e65-af7c-36cf0d60bcb0')): $__env->markAsRenderedOnce('2310a18b-c867-4e65-af7c-36cf0d60bcb0'); ?>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // File upload functionality
        const dropZone = document.getElementById('dropZone');
        const fileInput = document.getElementById('fileInput');
        const fileInfo = document.getElementById('fileInfo');
        const fileName = document.getElementById('fileName');
        const fileSize = document.getElementById('fileSize');
        const progressContainer = document.getElementById('progressContainer');
        const progressBar = document.getElementById('progressBar');
        const progressText = document.getElementById('progressText');

        // Drag and drop functionality
        if (dropZone) {
            dropZone.addEventListener('dragover', (e) => {
                e.preventDefault();
                dropZone.classList.add('dragover');
            });

            dropZone.addEventListener('dragleave', () => {
                dropZone.classList.remove('dragover');
            });

            dropZone.addEventListener('drop', (e) => {
                e.preventDefault();
                dropZone.classList.remove('dragover');

                const files = e.dataTransfer.files;
                if (files.length > 0) {
                    handleFile(files[0]);
                }
            });
        }

        // File input change
        if (fileInput) {
            fileInput.addEventListener('change', (e) => {
                if (e.target.files.length > 0) {
                    handleFile(e.target.files[0]);
                }
            });
        }

        function handleFile(file) {
            // Display file info
            if (fileName) fileName.textContent = file.name;
            if (fileSize) fileSize.textContent = formatFileSize(file.size);
            if (fileInfo) fileInfo.classList.add('show');

            // Simulate upload progress
            simulateUpload();
        }

        function formatFileSize(bytes) {
            if (bytes === 0) return '0 Bytes';
            const k = 1024;
            const sizes = ['Bytes', 'KB', 'MB', 'GB'];
            const i = Math.floor(Math.log(bytes) / Math.log(k));
            return parseFloat((bytes / Math.pow(k, i)).toFixed(2)) + ' ' + sizes[i];
        }

        function simulateUpload() {
            if (progressContainer) progressContainer.classList.add('show');
            let progress = 0;

            const interval = setInterval(() => {
                progress += Math.random() * 15;
                if (progress >= 100) {
                    progress = 100;
                    clearInterval(interval);

                    // Show success message
                    setTimeout(() => {
                        alert('✅ File uploaded successfully! Our experts will analyze your report shortly.');
                        if (progressContainer) progressContainer.classList.remove('show');
                    }, 500);
                }

                if (progressBar) progressBar.style.width = progress + '%';
                if (progressText) progressText.textContent = Math.round(progress) + '%';
            }, 200);
        }

        // Make clearFile function global
        window.clearFile = function() {
            if (fileInput) fileInput.value = '';
            if (fileInfo) fileInfo.classList.remove('show');
            if (progressContainer) progressContainer.classList.remove('show');
            if (fileName) fileName.textContent = 'No file selected';
            if (fileSize) fileSize.textContent = '0 KB';
            if (progressBar) progressBar.style.width = '0%';
            if (progressText) progressText.textContent = '0%';
        };

        // Add some interactive animations
        // Animate upload icon
        const uploadIcon = document.querySelector('.upload-icon');
        if (uploadIcon) {
            setInterval(() => {
                uploadIcon.style.transform = 'scale(1.1)';
                setTimeout(() => {
                    uploadIcon.style.transform = 'scale(1)';
                }, 200);
            }, 3000);
        }
    });
</script>
<?php endif; ?>



<?php /**PATH C:\laragon\www\labreportanlyst\resources\views/partials/upload.blade.php ENDPATH**/ ?>